# Washington Theme - Headless Shoporama Theme

## Oversigt

Washington er et moderne headless tema for Shoporama, bygget med:
- **Tailwind CSS** for styling
- **Alpine.js** for reaktivitet (til UI komponenter)
- **Vanilla JavaScript SPA** (`washington-spa-premium.js`) for hovedfunktionalitet
- **Shoporama Headless API** for al data og funktionalitet
- **Single Page Application (SPA)** arkitektur med client-side routing

## Features

- ✅ Komplet headless implementation
- ✅ Moderne, responsivt design med Tailwind UI
- ✅ Produktvisning og søgning (8 kolonner i søgeresultater)
- ✅ Fuld kurv/basket funktionalitet
- ✅ Komplet checkout flow
- ✅ Kunde login/registrering
- ✅ Real-time opdateringer uden sideopdatering
- ✅ **Infinite scroll** med automatisk indlæsning af næste sider
- ✅ **URL state management** - direkte links til specifikke sider (`?p=21`)
- ✅ **Optimeret performance** - 78% hurtigere API respons
- ✅ **Container layout** - produktvisning begrænset til 1400px bredde

## Installation

1. Kopier Washington mappen til `/user_templates/4/Washington/`
2. Aktiver temaet i Shoporama admin
3. Temaet bruger automatisk `/api` endpointet

## Struktur

```
Washington/
├── assets/
│   ├── js/
│   │   ├── washington-spa-premium.js  # Hoved SPA applikation med routing
│   │   ├── api-client.js              # Shoporama API client (legacy)
│   │   └── shop-app.js                # Shop applikation (legacy)
│   └── css/
│       └── tailwind.css               # Tailwind CSS
├── templates/
│   ├── global.html          # Hoved template
│   ├── index.html           # Forside
│   ├── product.html         # Produkt side
│   ├── category.html        # Kategori side
│   ├── basket.html          # Kurv
│   ├── address.html         # Checkout - adresse
│   ├── shipping.html        # Checkout - fragt
│   ├── payment.html         # Checkout - betaling
│   └── thanks.html          # Ordre bekræftelse
├── components/
│   └── sections.json        # Sektioner konfiguration
└── theme_settings.json      # Tema indstillinger
```

## API Endpoints

Temaet bruger følgende API endpoints:

- `GET /api` - Shop information
- `GET /api/frontpage?limit=20&offset=0` - Optimerede forside produkter med pagination
- `GET /api/products` - Produkter
- `GET /api/products/{id}` - Enkelt produkt detaljer
- `GET /api/categories` - Kategorier
- `GET/POST/PUT/DELETE /api/basket` - Kurv håndtering
- `POST /api/auth` - Login
- `POST /api/customer` - Registrering
- `POST /api/checkout` - Checkout proces
- `GET /api/search` - Søgning

## Teknologi

### Frontend
- **Tailwind CSS** via CDN for hurtig udvikling
- **Alpine.js** for reaktiv UI uden build step
- **LocalStorage** for basket token og auth persistens

### Backend
- **Shoporama Headless API** (`/api`)
- **Session-baseret** authentication med token support
- **CORS enabled** for cross-origin requests

## Udvikling

### Test siden

Åbn `/user_templates/4/Washington/test.html` i browseren for at teste API forbindelsen.

### Tilpasning

1. **Farver og styling**: Rediger Tailwind classes direkte i templates
2. **API client**: Modificer `/assets/js/api-client.js`
3. **App logik**: Rediger `/assets/js/shop-app.js`

### Bygge CSS (kun ved ændringer i Tailwind config)

CSS'en er allerede bygget og klar til brug i `assets/css/styles.css`.

Hvis du har brug for at genbygge CSS'en:

```bash
cd user_templates/4/Washington
npm install  # Installerer Tailwind og dependencies
npm run build-css  # Bygger production CSS
```

**Note:** node_modules mappen er ikke inkluderet i repository da den kun bruges til udvikling.

## Browser Support

- Chrome/Edge (nyeste)
- Firefox (nyeste)
- Safari (nyeste)
- Kræver JavaScript enabled

## Performance

- Lazy loading af billeder
- Minimal bundle size (ingen build required)
- CDN hosted dependencies
- API caching via browser

## Kendte Begrænsninger

- Kræver JavaScript for at fungere
- Ingen server-side rendering (SEO begrænsninger)

## Fremtidige Forbedringer

- [ ] Implementer fulde login/register modals
- [ ] Tilføj produkt filtrering
- [ ] Implementer wishlist funktionalitet
- [ ] Tilføj produkt anmeldelser
- [ ] PWA support med offline mode
- [ ] Implementer search autocomplete
- [ ] Tilføj loading skeletons

## Support

For hjælp med Washington temaet, kontakt Shoporama support eller se dokumentationen på `/projects/headless.md`.